#ONOMA: LEANDROS TZANAKIS-ARNAOUTAKIS
#AEM:985

## module gaussElimin
'''x = gaussElimin(a,b).
Solves [a]{b} = {x} by Gauss elimination'''

from numpy import dot
from numpy import array


a = array([[ 11.0, -5.0, 0.0, 0.0,0.0,-1.0], \
           [-20.0, 41.0,-15,0.0,-6.0,0.0], \
           [ 0.0, -3, 7.0,-4.0,0.0,0.0],\
           [0.0,0.0,-1.0,2.0,-1.0,0.0],\
           [0.0,-3.0,0.0,-10.0,28.0,-15.0],\
           [-2.0,0.0,0.0,0.0,-15.0,47.0]])

b = array([[ 250.0,  0.0,  0.0,0.0,0.0,0.0],\
           [500.0,0.0,0.0,0.0,0.0,0.0],\
           [750.0,0.0,0.0,0.0,0.0,0.0]])

def gaussElimin(a,b):
    n = len(b)
  # Elimination Phase(APALOIFH GAUSS)
    for k in range(0,n-1):
        for i in range(k+1,n):
           if a[i,k] != 0.0:
               lam = a [i,k]/a[k,k]
               a[i,k+1:n] = a[i,k+1:n] - lam*a[k,k+1:n]
               b[i] = b[i] - lam*b[k]
               
               
  # Back substitution(PISO OPISTHODROMISI)
    for k in range(n-1,-1,-1):
        b[k] = (b[k] - dot(a[k,k+1:n],b[k+1:n]))/a[k,k]
    return b

x = gaussElimin(a,b)  #H LUSH SYSTHMATOS

print x
  



